# 단일 연결 리스트

단일 연결 리스트는 선형으로 연결된 데이터 구조로, 노드로 구성되어 있다. 각 노드는 내용이 저장된 `data` 변수와 다음 노드를 가리키는 `pointer`로 구성되어 있다. 연결 리스트는 이런 노드들의 첫 원소를 가리키는 포인터를 가지며, 연산에 걸리는 시간을 훨씬 절약하기 위해 마지막 노드를 가리키는 포인터를 가질 수도 있다. 전체 노드 수를 저장하는 `length` 변수를 추가할 수도 있다.

### 배열보다 우수한 점

- 연결 리스트의 크기는 고정되어 있지 않다. (가변 크기)
- 배열에 비해 원소의 제거와 추가가 쉽다.

### 단점

- 원소에 순차적으로 접근해야 한다. (임의 접근 불가)
- 포인터를 저장하기 위해 추가적인 메모리가 필요하다.

### 시간 복잡도

| 작업 | 평균                                                                   | 최악                                                                   |
| ---- | ---------------------------------------------------------------------- | ---------------------------------------------------------------------- |
| 접근 | <img src="https://render.githubusercontent.com/render/math?math=O(n)"> | <img src="https://render.githubusercontent.com/render/math?math=O(n)"> |
| 탐색 | <img src="https://render.githubusercontent.com/render/math?math=O(n)"> | <img src="https://render.githubusercontent.com/render/math?math=O(n)"> |
| 삽입 | <img src="https://render.githubusercontent.com/render/math?math=O(1)"> | <img src="https://render.githubusercontent.com/render/math?math=O(1)"> |
| 제거 | <img src="https://render.githubusercontent.com/render/math?math=O(1)"> | <img src="https://render.githubusercontent.com/render/math?math=O(1)"> |

## 예시

```java
class LinkedList {
<<<<<<< HEAD
    Node head;      // 첫 원소를 가리키는 포인터
	Node tail;      // (Optional) 마지막 원소를 가리키는 포인터

	int length;     // (Optional) 전체 노드 수

    class Node {
        int data;   // 노드의 데이터
        Node next;  // 다음 노드를 가리키는 포인터
    }
}
```

## 구현

- [Java](https://github.com/TheAlgorithms/Java/blob/master/src/main/java/com/thealgorithms/datastructures/lists/SinglyLinkedList.java)
- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/Data%20Structure/Linked%20List.cpp)
- [Python](https://github.com/TheAlgorithms/Python/blob/master/data_structures/linked_list/singly_linked_list.py)
- [Ruby](https://github.com/TheAlgorithms/Ruby/blob/master/data_structures/linked_lists/single_list.rb)

## 영상 URL

- [CS50](https://www.youtube.com/watch?v=5nsKtQuT6E8)
